<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Review extends Model 
{

    protected $table = 'reviews';
    public $timestamps = true;
    protected $fillable = array('rating', 'comment', 'client_id', 'store_id');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function store()
    {
        return $this->belongsTo('App\Models\Store');
    }

}